#!/usr/bin/python3

import requests
import urllib

host_name = 'https://app.displayr.com'
uploaded_file_dictionary = {}
uploaded_data_files = []
print('Script started...')

def UploadFile(file_path):
        url = "%s/API/Upload" % host_name
        response = requests.post(url, files={'file': open(file_path, 'rb')})
        upload_id = response.headers['UploadID']
        uploaded_file_dictionary[file_path] = upload_id
        print("File %s uploaded as %s" % (file_path, upload_id))
        return upload_id

def UploadData(file_path):
        upload_id = UploadFile(file_path)
        uploaded_data_files.append( {'upload_id': upload_id, 'path': file_path} )


# A demonstration of creating a project using the displayr API. Details of the API can be found at
# https://app.displayr.com/API/
#
# -----------------------------------------------------------------------------
#
# Set the following variables based on the company you are working with:

# The following can be found in the company settings page if you are logged
# into displayr.com as a site admin. 
company_secret = 'insert-name-here-(contact-displayr-support)'

# New project name (must be unique):
new_project_name = 'insert-new-document-name-here'

# Contact name for new project
new_project_contact_name = 'Demo'

# Specify which files you want to upload. You refer to them in your qscript
# using this format: as <<<Filename.ext>>>. Use UploadData for any data you
# need to reference later when updating the data. The reference used will be
# the file name.
UploadFile('Line Plot.QTemplate')
UploadFile('Q Blue Logo.png')
UploadData('Phone.sav')

#
# -----------------------------------------------------------------------------

# Step 1: Create the project

# Read in Q Script and replace file names
with open('qscript.QScript', 'r') as file:
        qscript = file.read()

for key in uploaded_file_dictionary:
        qscript = qscript.replace("<<<%s>>>" % key, uploaded_file_dictionary[key])

# Step 2: Create project and upload QScript at the same time
print ('Creating project...')
url = "%s/API/NewProjectFromScript?company=%s&name=%s&public_url=false&contact=Fred" % (host_name, company_secret, new_project_name)
response = requests.post(url, data = qscript)
if 'ProjectSecret' in response.headers:
        project_secret = response.headers['ProjectSecret']
        print("Project '%s' created, with project secret: %s" % (new_project_name, project_secret))   
else:
        print('Project could not be created. Check that the project name is unique.')
        print(response.content)
        exit()
     
# Step 3: Create serials for uploaded data files so we can refer to them when updating data
for file_info in uploaded_data_files:
        params = {'project':project_secret,'data_name':file_info['path'].lower(),'upload_id':file_info['upload_id'],'new_serial':1,'abort':'OnWarning'}
        url = "%s/API/ImportUpdatedData?%s" % (host_name, urllib.parse.urlencode(params))
        response = requests.post(url)
        if response.status_code != 200:
                print("Problem using data file %s" % file_info['path'])
        print("Check this response contains no errors (should be a short HTML with 'success' in there):")
        print(response.content)
        
print('Done')